/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;

public class FileList {
    public static final String sVersion = "2016-08-20";
    final Args args;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    final SimpleDateFormat date_Format = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    final StringFormatter formatter = new StringFormatter(new StringBuilder(100));
    final CRC32 crcCalculator = new CRC32();
    String spaces = "                                                                                                    ";

    public FileList(Args args) {
        this.args = args;
        if (args.out == null) {
            args.out = System.out;
        }
    }

    public static void list(String string, String string2, String string3) throws IOException {
        Args args = new Args();
        args.sDirectory = string;
        args.crc = true;
        args.sMask = string2;
        args.sFileList = string + "/" + string3;
        FileList fileList = new FileList(args);
        fileList.list();
    }

    protected void xxxlist() throws IOException {
        LinkedList<FileFunctions.FileAndBasePath> linkedList = new LinkedList<FileFunctions.FileAndBasePath>();
        File file = this.args.sDirectory == null ? null : new File(this.args.sDirectory);
        FileSystem.addFilesWithBasePath(file, this.args.sMask, linkedList);
        TreeMap<String, FileFunctions.FileAndBasePath> treeMap = new TreeMap<String, FileFunctions.FileAndBasePath>();
        for (FileFunctions.FileAndBasePath object : linkedList) {
            boolean bl = false;
            if (object.localPath.startsWith("/.bzr")) {
                bl = true;
            }
            if (bl) continue;
            treeMap.put(object.localPath, object);
        }
        Object object = null;
        object = new FileWriter(this.args.sFileList);
        for (Map.Entry entry : treeMap.entrySet()) {
            FileFunctions.FileAndBasePath fileAndBasePath = (FileFunctions.FileAndBasePath)entry.getValue();
            this.writeOneFile((Writer)object, fileAndBasePath.file, fileAndBasePath.localPath, "");
        }
        if (object != null) {
            try {
                ((Writer)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void list() throws IOException {
        File file = new File(this.args.sDirectory);
        CharSequence charSequence = FileSystem.normalizePath(file);
        int n = charSequence.length() + 1;
        FileWriter fileWriter = null;
        fileWriter = new FileWriter(this.args.sFileList);
        this.list(file, n, "", fileWriter, 0);
        if (fileWriter != null) {
            ((Writer)fileWriter).close();
        }
    }

    protected void list(File file, int n, CharSequence charSequence, Writer writer, int n2) throws IOException {
        if (n2 > 100) {
            throw new IllegalArgumentException("to deep recursion");
        }
        System.out.println("Filelist.list dir=" + file.getAbsolutePath());
        File file2 = file.getAbsoluteFile();
        if (file2.exists()) {
            File[] fileArray = file2.listFiles();
            TreeMap<String, File> treeMap = new TreeMap<String, File>();
            for (File object2 : fileArray) {
                treeMap.put(object2.getName(), object2);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                String string;
                File file3 = (File)entry.getValue();
                if (file3.isDirectory() || (string = file3.getName()).charAt(0) == '.') continue;
                this.writeOneFile(writer, file3, charSequence, string);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                String string;
                File file4 = (File)entry.getValue();
                if (!file4.isDirectory() || (string = file4.getName()).charAt(0) == '.' || string.equals(this.args.sFileList)) continue;
                this.writeDirectoryLine(writer, file4, charSequence, string);
                CharSequence charSequence2 = FileSystem.normalizePath(file4);
                CharSequence charSequence3 = charSequence2.subSequence(n, charSequence2.length());
                this.list(file4, n, charSequence3, writer, n2 + 1);
            }
        }
    }

    private void writeOneFile(Writer writer, File file, CharSequence charSequence, String string) throws IOException {
        long l = file.lastModified();
        long l2 = file.length();
        this.formatter.reset();
        this.formatter.addint(l2, "2222222222.222 ");
        StringBuilder stringBuilder = new StringBuilder("       ");
        if (file.isDirectory()) {
            stringBuilder.setCharAt(1, 'D');
        }
        if (file.canExecute()) {
            stringBuilder.setCharAt(2, 'x');
        }
        if (!file.canRead()) {
            stringBuilder.setCharAt(3, 'h');
        }
        if (!file.canWrite()) {
            stringBuilder.setCharAt(4, 'r');
        }
        if (file.isHidden()) {
            stringBuilder.setCharAt(5, 'H');
        }
        int n = 0;
        if (this.args.crc && file.isDirectory()) {
            this.formatter.add("==DIR===");
        } else {
            try {
                int n2;
                this.crcCalculator.reset();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[4096];
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    this.crcCalculator.update(byArray, 0, n2);
                }
                ((InputStream)fileInputStream).close();
                n = (int)this.crcCalculator.getValue();
                this.formatter.addint(n, "-1111111111");
            }
            catch (Exception exception) {
                this.formatter.add("????????");
            }
        }
        this.formatter.add(' ');
        if (file.isDirectory()) {
            writer.append('\n');
        }
        writer.append(this.dateFormat.format(new Date(l)));
        writer.append(stringBuilder).append(' ');
        if (file.isDirectory()) {
            writer.append("=== ").append(charSequence);
            if (charSequence.length() > 0) {
                writer.append('/');
            }
            writer.append(string).append("/ ===");
            int n3 = charSequence.length() + string.length() + 1;
            if (n3 < 64) {
                writer.append("================================================================================".subSequence(0, 64 - n3));
            }
        } else {
            int n4 = string.length();
            if (string.contains(" ")) {
                writer.append("\"").append(string).append("\"");
                n4 += 2;
            } else {
                writer.append(string);
            }
            if (n4 < 40) {
                writer.append(this.spaces.subSequence(0, 40 - n4));
            }
            writer.append(" :: ");
            writer.append(this.formatter.getBuffer());
        }
        writer.append("\n");
    }

    private void writeDirectoryLine(Writer writer, File file, CharSequence charSequence, String string) throws IOException {
        writer.append("\n============================== ").append(charSequence);
        if (charSequence.length() > 0) {
            writer.append('/');
        }
        writer.append(string).append("/ ===");
        int n = charSequence.length() + string.length() + 1;
        if (n < 64) {
            writer.append("================================================================================".subSequence(0, 64 - n));
        }
        writer.append("\n");
    }

    private void xxxwriteOneFile(Writer writer, File file, CharSequence charSequence) throws IOException {
        long l = file.lastModified();
        l = (l + 5000L) / 10000L * 10000L;
        long l2 = file.length();
        this.formatter.reset();
        this.formatter.addint(l2, "2222'222'222'222 ");
        StringBuilder stringBuilder = new StringBuilder("       ");
        if (file.isDirectory()) {
            stringBuilder.setCharAt(1, 'D');
        }
        if (file.canExecute()) {
            stringBuilder.setCharAt(2, 'x');
        }
        if (!file.canRead()) {
            stringBuilder.setCharAt(3, 'h');
        }
        if (!file.canWrite()) {
            stringBuilder.setCharAt(4, 'r');
        }
        if (file.isHidden()) {
            stringBuilder.setCharAt(5, 'H');
        }
        int n = 0;
        if (this.args.crc && file.isDirectory()) {
            this.formatter.add("==DIR===");
        } else {
            try {
                int n2;
                this.crcCalculator.reset();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[4096];
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    this.crcCalculator.update(byArray, 0, n2);
                }
                ((InputStream)fileInputStream).close();
                n = (int)this.crcCalculator.getValue();
                this.formatter.addHex(n, 8);
            }
            catch (Exception exception) {
                this.formatter.add("????????");
            }
        }
        this.formatter.add(' ');
        writer.append(this.dateFormat.format(new Date(l)));
        writer.append(stringBuilder);
        writer.append(this.formatter.getBuffer());
        writer.append(charSequence);
        writer.append("\n");
    }

    public static void touch(String string, String string2, String string3, Appendable appendable) throws IOException {
        Args args = new Args();
        args.out = appendable;
        if (string2 == null) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(92);
            if (n2 > n) {
                n = n2;
            }
            args.sDirectory = string.substring(0, n);
            args.sFileList = string;
        } else {
            args.sDirectory = string;
            args.sFileList = string + "/" + string2;
        }
        args.crc = true;
        args.sMask = "*";
        FileList fileList = new FileList(args);
        fileList.touch(string3);
    }

    public static void touch(String string, String string2, Appendable appendable) throws IOException {
        FileList.touch(string, string2, null, appendable);
    }

    public void touch() {
        this.touch(null);
    }

    public void touch(String string) {
        BufferedReader bufferedReader = null;
        File file = new File(this.args.sDirectory).getAbsoluteFile();
        String string2 = "";
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(this.args.sFileList));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = this.touchOneLine(string3, file, string2, string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String touchOneLine(String string, File file, String string2, String string3) {
        String string4 = string2;
        try {
            if (string.startsWith("===================")) {
                int n = string.indexOf(32) + 1;
                int n2 = string.indexOf("================", n) - 1;
                if (n > 0 && n2 > n) {
                    string4 = string.substring(n, n2);
                }
            } else if (string.length() > 20) {
                String string5;
                int n;
                long l;
                Date date = string.charAt(10) == '_' ? this.date_Format.parse(string) : this.dateFormat.parse(string);
                long l2 = date.getTime();
                if (string.charAt(30) == '\'') {
                    l = StringFunctions_C.parseLong(string, 26, 16, 10, null, " '");
                    n = StringFunctions_C.parseIntRadix(string, 43, 8, 16, null);
                    String string6 = string.substring(53).trim();
                    int n3 = string6.length();
                    if (string6.charAt(0) == '\"' && string6.charAt(n3 - 1) == '\"') {
                        string6 = string6.substring(1, n3 - 1);
                    }
                    string5 = string2 + string6;
                } else if (StringFunctions.equals(string.subSequence(27, 30), "===")) {
                    l = -1L;
                    n = 0;
                    string5 = null;
                    int n4 = string.indexOf(" ===", 31);
                    if (n4 < 0) {
                        n4 = string.length();
                    }
                    string4 = string.substring(31, n4);
                } else {
                    int n5 = string.indexOf("::");
                    String string7 = string.substring(27, n5).trim();
                    int n6 = string7.length();
                    if (string7.charAt(0) == '\"' && string7.charAt(n6 - 1) == '\"') {
                        string7 = string7.substring(1, n6 - 1);
                    }
                    string5 = string2 + string7;
                    l = StringFunctions_C.parseLong(string, n5 + 2, 16, 10, null, " .");
                    n = (int)StringFunctions_C.parseLong(string, n5 + 18, 11, 10, null, " ");
                }
                if (string5 != null && (string3 == null || string3.equals(string5))) {
                    File file2 = new File(file, string5);
                    if (!file2.exists()) {
                        if (this.args.out != null) {
                            this.args.out.append("FileList - touch, file not exist; ").append(string5).append("\n");
                        }
                    } else if (!file2.isDirectory()) {
                        long l3 = file2.lastModified();
                        if (file2.length() == l) {
                            if (Math.abs(l2 - l3) > 10000L) {
                                int n7;
                                this.crcCalculator.reset();
                                FileInputStream fileInputStream = new FileInputStream(file2);
                                byte[] byArray = new byte[4096];
                                while ((n7 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                                    this.crcCalculator.update(byArray, 0, n7);
                                }
                                ((InputStream)fileInputStream).close();
                                int n8 = (int)this.crcCalculator.getValue();
                                if (n8 == n) {
                                    file2.setLastModified(l2);
                                    if (this.args.out != null) {
                                        this.args.out.append("FileList - touching; ").append(string5).append("\n");
                                    }
                                } else if (this.args.out != null) {
                                    this.args.out.append("FileList - touch, file with same length is changed; ").append(string5).append("\n");
                                }
                            }
                        } else if (this.args.out != null) {
                            this.args.out.append("FileList - touch, file is changed; ").append(string5).append("\n");
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return string4;
    }

    public static void main(String[] stringArray) {
        FileList.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return FileList.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string = null;
        int n = 0;
        Args args = new Args();
        System.out.println(args.aboutInfo());
        try {
            args.parseArgs(stringArray, System.err);
            if (!args.testArgs(System.err)) {
                return "";
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return exception.getMessage();
        }
        try {
            if (args.cCmd != '\u0000') {
                FileList fileList = new FileList(args);
                if (string == null) {
                    try {
                        switch (args.cCmd) {
                            case 'L': {
                                fileList.list();
                                break;
                            }
                            case 'T': {
                                fileList.touch();
                                break;
                            }
                            default: {
                                new IllegalArgumentException("illegal cmd: " + args.cCmd);
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        string = "FileList - Any internal error;" + exception.getMessage();
                        n = 6;
                    }
                }
            } else {
                args.showHelp(System.out);
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        if (bl) {
            System.exit(n);
        }
        return string;
    }

    public static class Args
    extends Arguments {
        public char cCmd;
        public String sDirectory;
        public String sMask;
        public Appendable out;
        public boolean crc = true;
        public String sFileList;
        Arguments.SetArgument setCmd = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                cCmd = string.charAt(0);
                return true;
            }
        };
        Arguments.SetArgument setListfile = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sFileList = string;
                return true;
            }
        };
        Arguments.SetArgument setDir = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sDirectory = string;
                return true;
            }
        };
        Arguments.SetArgument setMask = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sMask = string;
                return true;
            }
        };

        Args() {
            this.aboutInfo = "Generating a list of files or evaluating it \nmade by HSchorrig, Version 1.0, 2013-08-07..2020-06-16";
            this.helpInfo = "obligate: [L|T|C|D] -l:.files ";
            this.addArg(new Arguments.Argument("", "[L|T|C|D]: List, Touch date, Compare, last files per Date", this.setCmd));
            this.addArg(new Arguments.Argument("-l", ":<files.txt> The list file ", this.setListfile));
            this.addArg(new Arguments.Argument("-d", ":<directory path>  ", this.setDir));
            this.addArg(new Arguments.Argument("-m", ":<Mask> mask of files", this.setMask));
        }

        @Override
        public boolean testArgs(Appendable appendable) throws IOException {
            return true;
        }
    }
}

