function lib_WaveMng_genSfn()
%
%% Generates Sfunction wrapper and tlc file from information in the header file. 
% NOTE: This file needs a licensed script file see include statement in this script
% Please contact hartmut.schorrig@vishia.de to get more information.
% The generated wrapper and tlc should be stored additionally, so you can% compile 
% mex files nevertheless with unchanged S-function wrapper (unchanged interface of the Sfunction)
%
rootPath = evalin('base', 'rootPath');
display(rootPath);
clc;
clear mex;
currdir_ = pwd;
cd(rootPath);
disp('Generate S-Fuctions for lib_WaveMng ...');
system('java.exe -cp ../libs/vishiaBase.jar org.vishia.jztxtcmd.JZtxtcmd main/Smlk/libSfn_Ctrl/+mkSfn/lib_WaveMng_genSfn.m');
genBus.lib_WaveMng_genBus();  %just generated script
genSfn.lib_WaveMng_mexdbg();    %just generated script.
genSfn.lib_WaveMng_mex();    %just generated script.
disp('successfull');
system('time /T');
cd(currdir_);
clear mex;

end
%{
==JZtxtcmd==
currdir = <:><&scriptdir>/../../../..<.>;   ##the currdir should be the simulink root dir.
include ../../SmlkSfunc_jzTc/simulinkSfuncBusGen.jzTc;  ##out of the box, see below

##Important note: To complile the Sfunctions newly you need three things outside of this simulink box.
##They should be placed in file system parallel to this this current dir 'smlk/SMLK_PRJ/Simulink'.
##1. The JZtxtcmd script engine. It is contained in 'Java/vishiajar/zbnf.jar'.
##   It is only used in the Java invocation as class path.
##2. Sources of Library C-functions. 
##3. The scripts to generate S-Funtion wrapper. This script is included above with relative path.
##   This scripts are not open source. you can get it with a low fee (one week coaching) from vishia.org.


Subtextvar mexAddCmd = <:>
system('copy "main\Smlk\lib_Sfn\+mkSfn\emC_rtwmakecfg.m$" "<&dirMexWin>\rtwmakecfg.m"');
<.>;


##from this header Sfunctions are generated.
Fileset srcHeader =  
( main/cpp/src_emC:emC/Ctrl/WaveMng_Ctrl_emC.h
);



Fileset includepath = 
( main/cpp/src_emC
, main/cpp/src_emC/emC_inclApplSpec/stdef_SmlkSfuncExcH
, main/cpp/src_emC/emC_inclComplSpec/cc_SmlkSfunc_64bit
);




## All sources for compilation to the named header file, for rapid accelerator, except the generated Sfunc-wrapper.
Fileset srcTlc_WaveMng_Ctrl_emC = 
( main/cpp/src_emC/emC/Ctrl/WaveMng_Ctrl_emC.c     ##same c-file as header
);


## All sources for compilation to the named header file, except the generated Sfunc-wrapper.
Fileset src_WaveMng_Ctrl_emC = 
( &srcTlc_WaveMng_Ctrl_emC      ##Use the sources for rapid accelerator
, main/cpp/src_emC/emC_srcApplSpec/applConv/ApplThrowOnFatalError_emC.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ExceptionPrintStacktrace_emC.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ExcThCxtStacksize.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ObjectJc_allocStartup_emC.c
, main/cpp/src_emC/emC/Base/Assert_emC.c
, main/cpp/src_emC/emC/Base/CheckStack_emC.c
, main/cpp/src_emC/emC/Base/DefPortTypes_emC.c
, main/cpp/src_emC/emC/Base/ExceptionCpp_emC.cpp
, main/cpp/src_emC/emC/Base/ExcThreadCxt_emC.c
, main/cpp/src_emC/emC/Base/MemC_emC.c
, main/cpp/src_emC/emC/Base/Memfree_ThreadAndBlockHeap.c
, main/cpp/src_emC/emC/Base/ObjectSimple_emC.c
, main/cpp/src_emC/emC/Base/ObjectRefl_emC.c
, main/cpp/src_emC/emC/Base/Time_emC.c
, main/cpp/src_emC/emC/Base/Timeconversions_emC.c
, main/cpp/src_emC/emC/Base/Reflection_emC.c
, main/cpp/src_emC/emC/Base/ReflectionBaseTypes_emC.c
##, main/cpp/src_emC/emC/Base/String_emC.c
, main/cpp/src_emC/emC/Base/StringBase_emC.c
##, main/cpp/src_emC/emC/Base/StringBuilder_emC.c
, main/cpp/src_emC/emC/Base/Handle_ptr64_emC.c
, main/cpp/src_emC/emC/Base/Handle_ptr64_TimeMeas_emC.c
, main/cpp/src_emC/emC/Base/os_common.c
, main/cpp/src_emC/emC/OSAL/Environment_OSALemC.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows_Msc15/os_atomic.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_environment.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_file.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_mem.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_mutex.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_sharedmem.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_sync.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_thread.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_time.c
);





##Docu: if this Subtextvar is found, the memory for the Object Function Blocks is gotten in the function InitializeConditions.
##If the genAllocmem is not existing or null, The Sfunctions will get a second output for a bus which presents the internal data.
##Because the code generation provides a memory space with pointer, that is used.
##Note that some special condition 'don't reuse' etc. should be set for code generation optimizations.
##
Subtextvar genAllocmem(String dst, String nameStruct, Num ident) =
<:>(<&nameStruct>*) malloc(sizeof(<&nameStruct>))  /*JZtc: user-specific ExampleObjO*/ <.>;

main() { ##main routine for the JZtxtcmd:

  zmake "main/Smlk/libSfn_Ctrl:lib_WaveMng" := simulinkSfuncBusGen(&srcHeader
    , coptions="-TP -EHa"
    , dirRefl = null ##Reflections are part of the emC sources.
    , fileBus = ":+genBus/lib_WaveMng_genBus.m"
    , dirMexDbg = "../mexDbg", dirMex = "main/Smlk/libSmlk/mex"
    , dirMexcc=":+genSfn", dirSfunc = ":+genSfn/Ctrl", dirTlc = ":+genSfn/Ctrl"
    ##, html=":test.html"  ##only for internally data view
    );

}

==endJZcmd==
%}
