
function lib_Inspc_genBusSfunc()
%
%% Generates Sfunction wrapper and tlc file from information in the header file. 
% NOTE: This file needs a licensed script file see include statement in this script
% Please contact hartmut.schorrig@vishia.de to get more information.
% The generated wrapper and tlc should be stored additionally, so you can% compile 
% mex files nevertheless with unchanged S-function wrapper (unchanged interface of the Sfunction)
%
rootPath = evalin('base', 'rootPath');
display(rootPath);
clc;
clear mex;
currdir_ = pwd;
cd(rootPath);
disp('Generate S-Fuctions for lib_Inspc ...');
system('java.exe -cp ../libs/vishiaBase.jar org.vishia.jztxtcmd.JZtxtcmd   main/Smlk/libSfn_Inspc/+mkSfn/lib_Inspc_genSfH.m');
%genSfn.lib_Inspc_mexdbg();    %just generated script.
genSfn.lib_Inspc_mex();    %just generated script.
disp('successfull');
system('time /T');
cd(currdir_);
end
%{
==JZtxtcmd==
currdir = <:><&scriptdir>/../../../..<.>;   ##the currdir should be the simulink root dir.
include ../../SmlkSfunc_jzTc/simulinkSfuncBusGen.jzTc;  ##out of the box, see below

##Important note: To complile the Sfunctions newly you need three things outside of this simulink box.
##They should be placed in file system parallel to this this current dir 'smlk/SMLK_PRJ/Simulink'.
##1. The JZtxtcmd script engine. It is contained in 'zbnfjax/zbnfjax.zbnf'.
##   It is only used in the Java invocation as class path.
##2. Sources of Inspector. They are part of the 'emC' source pool, hosted on Github /jzHartmut.
##   That sources are used here in a directory parallel to this current dir 'smlk/*/Simulink' in 'emc/*'
##3. The scripts to generate S-Funtion wrapper. This script is included above with relative path.
##   This scripts are not open source. you can get it with a low fee (one week coaching) from vishia.org.

Subtextvar mexAddCmd = <:>
system('copy "main/Smlk/libSfn_Inspc\+mkSfn\emC_rtwmakecfg.m$" "<&dirMexWin>\rtwmakecfg.m"');
socketlib = { fullfile(matlabroot,'sys\lcc64\lcc64\lib64\ws2_32.lib')} 
socketlibcopy = strjoin(['copy ', socketlib, ' main\Smlk\libSmlk\mex\*']);
system(socketlibcopy); %%copy the socket lib to a local position.
<.>;




Fileset srcHeader =  ##from this header Sfunctions are generated.
( main/cpp/src_emC:emC/Inspc/FB/DataStruct_Inspc.h  ##hint: translate always with Access_DataStruct_Inspc.h
, main/cpp/src_emC:emC/Inspc/FB/Access_DataStruct_Inspc.h
, main/cpp/src_emC:emC/Inspc/FB/TimeSignals_Inspc.h  ##Stimulation for Simulink
, main/cpp/src_emC:emC/Inspc/Srv/Service_Inspc.h   ##The core FB for Inspector service
, main/cpp/src_emC:emC/Inspc/Srv/DataNode_Inspc.h
##not ready yet: , ../../emC_Inspc:Inspc/Wait_Inspc.h
, main/cpp/src_emC:emC/Inspc/FB/GetValue_Inspc.h   ##access to internal data, output to simulink
);


Fileset includepath = 
( main/cpp/src_emC
, main/cpp/src_emC/emC_inclApplSpec/stdef_SmlkSfuncExcH
, main/cpp/src_emC/emC_inclComplSpec/cc_SmlkSfunc_64bit
);



## All sources for compilation to the named header file, except the generated Sfunc-wrapper.
Fileset src_Base_emC = 
( main/cpp/src_emC/emC_srcApplSpec/applConv/ApplThrowOnFatalError_emC.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ExceptionPrintStacktrace_emC.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ExcThCxtStacksize.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/ObjectJc_allocStartup_emC.c
, main/cpp/src_emC/emC_srcApplSpec/applConv/UmlContainer_Dummy.c
, main/cpp/src_emC/emC/Base/Assert_emC.c
, main/cpp/src_emC/emC/Base/CheckStack_emC.c
, main/cpp/src_emC/emC/Base/DefPortTypes_emC.c
, main/cpp/src_emC/emC/Base/ExceptionCpp_emC.cpp
, main/cpp/src_emC/emC/Base/ExcThreadCxt_emC.c
, main/cpp/src_emC/emC/Base/Formatter_emC.c
, main/cpp/src_emC/emC/Base/MemC_emC.c
, main/cpp/src_emC/emC/Base/Memfree_ThreadAndBlockHeap.c
, main/cpp/src_emC/emC/Base/ObjectSimple_emC.c
, main/cpp/src_emC/emC/Base/ObjectRefl_emC.c
, main/cpp/src_emC/emC/Base/Object_RAMclass_emC.c
, main/cpp/src_emC/emC/Base/Time_emC.c
, main/cpp/src_emC/emC/Base/Timeconversions_emC.c
, main/cpp/src_emC/emC/Base/Reflection_emC.c
, main/cpp/src_emC/emC/Base/ReflectionBaseTypes_emC.c
, main/cpp/src_emC/emC/Base/String_emC.c
, main/cpp/src_emC/emC/Base/StringBase_emC.c
, main/cpp/src_emC/emC/Base/StringBuilder_emC.c
, main/cpp/src_emC/emC/Base/Handle_ptr64_emC.c
, main/cpp/src_emC/emC/Base/Handle_ptr64_TimeMeas_emC.c
, main/cpp/src_emC/emC/Base/os_common.c
, main/cpp/src_emC/emC/Jc/ObjectJc.c
, main/cpp/src_emC/emC/Jc/StringJc.c
, main/cpp/src_emC/emC/Jc/StringBufferJc.c
, main/cpp/src_emC/emC/Jc/SystemJc.c
, main/cpp/src_emC/emC/Jc/MathJc.c
, main/cpp/src_emC/emC/J1c/StringFunctionsJc.c
, main/cpp/src_emC/emC/J1c/StringFunctions_CJc.c
, main/cpp/src_emC/emC/J1c/StringPartJc.c
, main/cpp/src_emC/emC/J1c/StringPartScanJc.c
, main/cpp/src_emC/emC/Jc/ReflectionJc.c
, main/cpp/src_emC/emC/Jc/ReflectionBaseTypesJc.c
, main/cpp/src_emC/emC/Jc/ReflMemAccessJc.c
, main/cpp/src_emC/emC/Jc/FileIoJc.c                          
, main/cpp/src_emC/emC/Jc/LocaleJc.c
, main/cpp/src_emC/emC/OSAL/Environment_OSALemC.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows_Msc15/os_atomic.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_file.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_mem.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_mutex.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_sharedmem.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_sync.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_thread.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_time.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_environment.c
);



## All sources for compilation to the named header file, except the generated Sfunc-wrapper.
Fileset src_TimeSignals_Inspc = 
( main/cpp/src_emC/emC/Inspc/FB/TimeSignals_Inspc.c
, main/cpp/src_emC/emC/Inspc/Srv/DataNode_Inspc.c
, main/cpp/src_emC/emC/Inspc/FB/DataStructBase_Inspc.c
, main/cpp/src_emC/emC/Inspc/FB/DataStruct_Inspc.cpp
, main/cpp/src_emC/emC/Inspc/FB/Access_DataStruct_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/SearchElement_Inspc.c
, &src_Base_emC
);



Fileset src_DataStruct_Inspc = 
( &src_Base_emC
, main/cpp/src_emC/emC/Inspc/FB/Access_DataStruct_Inspc.c
, main/cpp/src_emC/emC/Inspc/FB/DataStruct_Inspc.cpp
, main/cpp/src_emC/emC/Inspc/FB/DataStructBase_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/SearchElement_Inspc.c
);


Fileset src_GetValue_Inspc = 
( &src_Base_emC
, main/cpp/src_emC/emC/Inspc/FB/GetValue_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/SearchElement_Inspc.c
);



Fileset src_DataNode_Inspc = 
( &src_Base_emC
, main/cpp/src_emC/emC/Inspc/Srv/DataNode_Inspc.c
);



Fileset src_Access_DataStruct_Inspc = 
( &src_Base_emC
, main/cpp/src_emC/emC/Inspc/FB/Access_DataStruct_Inspc.c
, main/cpp/src_emC/emC/Inspc/FB/DataStruct_Inspc.cpp
, main/cpp/src_emC/emC/Inspc/FB/DataStructBase_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/SearchElement_Inspc.c
);


Fileset src_Test_Out_DataStruct_Inspc = (&src_Out_DataStruct_Inspc);





## All sources for compilation to the named header file, except the generated Sfunc-wrapper.
Fileset src_Wait_Inspc = 
( ../../emC_Inspc/Inspc_FB/Wait_Inspc.c
##, ../../emC_Inspc/Inspc/FBaccessNode_RegisterRefl_Inspc.c
, ../../emC/Fwc/fw_ReflectionBaseTypes.c
, ../../emC/Fwc/fw_Object.c
, ../../emC/Base/time_emC.c
, ../../emC/Fwc/fw_MemC.c
, ../../emC/Fwc/fw_SimpleC.c
, ../../emC/Fwc/fw_String.c
, ../../emC/Fwc/fw_Formatter.c
, ../../emC/Fwc/fw_timeconversions.c
, ../../emC/Fwc/fw_ThreadContext.c
, ../../emC/Jc/ObjectJc.c
, ../../emC/Base/CheckStack_emC.c
, ../../emC/Jc/StringJc.c
, ../../emC/Jc/StringBufferJc.c
, ../../emC/Base/Handle_ptr64_emC.c
, ../../emC/Base/Handle_ptr64_TimeMeas_emC.c
, ../../emC/Fwc/fw_Exception.c
, ../../emC/Fwc/fw_ExceptionPrintStacktrace.c
, ../../emC/sourceSpecials/FwConv_c/allocOnlyAtStartup.c
, ../../emC/sourceSpecials/FwConv_c/fw_PlatformConvSimpleStop.c 
, ../../emC/sourceSpecials/FwConv_c/free_ThreadHeapAndBlockHeap.c
, ../../emC/sourceSpecials/osal_Windows_Msc15/os_atomic.c  
##, ../../emC/refl/Reflection_OSAL.c
, ../../emC/sourceSpecials/os_Windows_64/os_mem.c
, ../../emC/sourceSpecials/os_Windows_64/os_file.c
, ../../emC/sourceSpecials/os_Windows_64/os_time.c
, ../../emC/sourceSpecials/os_Windows_64/os_error.c
, ../../emC/sourceSpecials/os_Windows_64/os_mutex.c
, ../../emC/sourceSpecials/os_Windows_64/os_thread.c
, ../../emC/sourceSpecials/os_Windows_64/os_sharedmem.c
);








Fileset src_Service_Inspc = 
( main/cpp/src_emC/emC/Inspc/Srv/Service_Inspc.c
, main/cpp/src_emC/emC/Inspc/Srv/DataNode_Inspc.c
, main/cpp/src_emC/emC/Inspc/Srv/CheckPwd_MinDefault_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/AnswerComm_ifc_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/ClassContent_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/CmdConsumer_ifc_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/CmdExecuter_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/Comm_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/InspcDataExchangeAccess_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/InspcDataInfo_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/Inspector_Inspc.c
, main/cpp/src_emC/emC/Inspc/J2c/SearchElement_Inspc.c
, main/cpp/src_emC/emC/Ipc/InterProcessCommSocket.c
, main/cpp/src_emC/emC/Ipc/Ipc2c/InterProcessCommFactorySocket_Ipc.c
, main/cpp/src_emC/emC/Ipc/InterProcessComm.c
, main/cpp/src_emC/emC/J1c/ByteDataAccessBaseJc.c
, main/cpp/src_emC/emC/Jc/ArraysJc.c
, main/cpp/src_emC/emC/Jc/CharsetJc.c
, main/cpp/src_emC/emC/Jc/OsWrapperJc.c
, main/cpp/src_emC/emC/Jc/PrintStreamJc.c
, main/cpp/src_emC/emC/Jc/StringValueConvJc.c
, main/cpp/src_emC/emC/Jc/SystemOutJc.c
, main/cpp/src_emC/emC/Jc/ThreadJc.c
, main/cpp/src_emC/emC_srcOSALspec/osal_Windows/os_socket.c
, main/cpp/src_emC/emC/Base/Endianess_emC.c
, main/cpp/src_emC/emC/Base/SimpleC_emC.c
, &src_Base_emC
);




Fileset lib_Service_Inspc = 
( main/Smlk/libSmlk/mex/ws2_32
##, mex/Inspc_SmlkAccl
 //, C:\Programs\Matlab\R2016a\sys\lcc64\lcc64\lib64\ws2_32
);                                                              




##Docu: if this Subtextvar is found, the memory for the Object Function Blocks is gotten in the function InitializeConditions.
##If the genAllocmem is not existing or null, The Sfunctions will get a second output for a bus which presents the internal data.
##Because the code generation provides a memory space with pointer, that is used.
##Note that some special condition 'don't reuse' etc. should be set for code generation optimizations.
##
Subtextvar genAllocmem(String dst, String nameStruct, Num ident) =
<:>(<&nameStruct>*) malloc(sizeof(<&nameStruct>))  /*JZtc: user-specific ExampleObjO*/ <.>;

main() { ##main routine for the JZtxtcmd:

  zmake "main/Smlk/libSfn_Inspc:lib_Inspc" := simulinkSfuncBusGen(&srcHeader
    , coptions="-TP -EHa" 
    , dirRefl = null ##Reflections are part of the emC sources.
    ##, dirMexDbg = "../mexDbg"
    , dirMexDbg = "C:/smlk/mexDbg"
    , dirMex = "main/Smlk/libSmlk/mex"
    , dirMexcc=":+genSfn", dirSfunc = ":+genSfn/Inspc", dirTlc = ":+genSfn/Inspc"
    ##, html=":test.html"  ##only for internally data view
    );

  ##copy manual adapted tlc, overwrite the autogenerated ones, last ones are faulty in this context
  <+out>copy libSfn_Inspc/+mkSfn/tlc_src/*: <.+> 
  copy -w main/Smlk/libSfn_Inspc/+mkSfn/tlc_src/* main/Smlk/libSfn_Inspc/+genSfn/Inspc;
  
  
    
}

==endJZcmd==
%}
