function makeInfo = rtwmakecfg()
%%This file will be copied to mex/rtwmakecfg.m on generation of mex. It is for the emC environment.
%Absolute paths are necessary because the working dir for rapid accelerator can be places remote.
%Settings in Simulink preferences, General, simulation cache folder.
rootPath = evalin('base', 'rootPath');  %It is the root for the Simulink session, common style
addIncludepath = evalin('base', 'addIncludepath_rtwmakecfg');  %It is the path for all DataStructMng_Inspc FBlocks for this model
addSrcpath = evalin('base', 'addSrcpath_rtwmakecfg');  %It is the path for all DataStructMng_Inspc FBlocks for this model
addSrc = evalin('base', 'addSrc_rtwmakecfg');  %It is the path for all DataStructMng_Inspc FBlocks for this model
emcPath = "D:/vishia/emc";    %The full emc sources (embedded multiplatform C basic sources)

%Text to detect in diagnostic viewer output:
disp("======= rtmakecfg - lib_emC ==============================");

%Include path for the rapid accelerator compilation
makeInfo.includePath = ...
{ fullfile(emcPath, "incApplSpecific/stdef_SmlkAccelerator") ...
, fullfile(emcPath, "incComplSpecific/cc_SmlkSfunc_64bit") ...
, fullfile(emcPath, "source") ...
, emcPath ...
, addIncludepath ...
, rootPath ...
};


%The additional source files are necessary to determine 
% the emC applspec behaviour outside of the library functinality
makeInfo.sources = ...
{ "ApplThrowOnFatalError_emC.c" ...
, addSrc ...
};

%if sources are named in the tlc-file they are searched in the following paths.
%Only if the source is found, a compilation is started, elsewhere the obj is expected in a library.
%Hint: The sources are written in the tlc file with the 'Fileset srcTlc_... = ...' 
%      in the +mkSfn/...m wrapper generation script. 
makeInfo.sourcePath = ...
{ fullfile(emcPath, "sourceApplSpecific/applConv") ...
, addSrcpath ...
};

%Additional libs for the rapid accelerator linking
makeInfo.linkLibsObjs = ...
{ fullfile(rootPath, "lib/mex/libMsc15_emC.lib") ...
};
end
