#ifndef __Device_ObjMod_h__
#define __Device_ObjMod_h__
#include <applstdef_emC.h>





struct MeasPrep_ProgrSimpleExmplA_t;
struct Controller_ObjMod_t;
struct ParamOptimizer_ObjMod_t;
struct RefValueCtrl_t;
typedef struct Device_ObjMod_t {
  union { ObjectJc object; } base;

  float refValues[2];

  uint16 stop_Optimize;

  boolean run;

  float Yport[2];

  struct MeasPrep_ProgrSimpleExmplA_t * measPrep;

  struct Controller_ObjMod_t * controller;

  struct ParamOptimizer_ObjMod_t * parOptimizer;

  struct RefValueCtrl_t * refValueCtrl;
} Device_ObjMod_s;

extern_C ClassJc const refl_Device_ObjMod;

void ctor_Device_ObjMod(Device_ObjMod_s* thiz);


/**Write data to DataStruct. 
 * Note: The Simulink coder cannot decide whether it is a scalar, vector or pointer
 * Therefore all arguments are unique given as address (pointer) 
 */

bool init__Device_ObjMod(Device_ObjMod_s* thiz, uint16 const* stop_Optimize, uint32 const* controller, uint32 const* parOptimizer, uint32 const* refValueCtrl);


void step__Device_ObjMod(Device_ObjMod_s* thiz, float const* refValues, bool const* run, float const* Yport, uint32 const* measPrep);


inline void get_refValues_Device_ObjMod(Device_ObjMod_s* thiz, float* refValues) {
  memcpy(refValues, thiz->refValues, sizeof(thiz->refValues));//float
}

inline void get_stop_Optimize_Device_ObjMod(Device_ObjMod_s* thiz, uint16* stop_Optimize) {
  *stop_Optimize = thiz->stop_Optimize;
}

inline void get_run_Device_ObjMod(Device_ObjMod_s* thiz, boolean* run) {
  *run = thiz->run;
}

inline void get_Yport_Device_ObjMod(Device_ObjMod_s* thiz, float* Yport) {
  memcpy(Yport, thiz->Yport, sizeof(thiz->Yport));//float
}

inline void get_measPrep_Device_ObjMod(Device_ObjMod_s* thiz, uint32* measPrep) {
  //In the simulink data a handle is stored, in the generated struct it is a really pointer. Convert it:
  *measPrep = HANDLE_Handle2Ptr(thiz->measPrep);
}

inline void get_controller_Device_ObjMod(Device_ObjMod_s* thiz, uint32* controller) {
  //In the simulink data a handle is stored, in the generated struct it is a really pointer. Convert it:
  *controller = HANDLE_Handle2Ptr(thiz->controller);
}

inline void get_parOptimizer_Device_ObjMod(Device_ObjMod_s* thiz, uint32* parOptimizer) {
  //In the simulink data a handle is stored, in the generated struct it is a really pointer. Convert it:
  *parOptimizer = HANDLE_Handle2Ptr(thiz->parOptimizer);
}

inline void get_refValueCtrl_Device_ObjMod(Device_ObjMod_s* thiz, uint32* refValueCtrl) {
  //In the simulink data a handle is stored, in the generated struct it is a really pointer. Convert it:
  *refValueCtrl = HANDLE_Handle2Ptr(thiz->refValueCtrl);
}
#endif  //__Device_ObjMod_h__
