#ifndef __ParamOptimizer_ObjMod_h__
#define __ParamOptimizer_ObjMod_h__
#include <applstdef_emC.h>





struct ParFactors_PIDf_Ctrl_emC_t;
typedef struct ParamOptimizer_ObjMod_t {
  union { ObjectJc object; } base;

  /**...Comment.
   * @acclevel=03.
   */
  float f_Y12;

  /**...Comment.
   * @acclevel=40.
   */
  float reserve;

  float Ystim[2];

  /**...Comment.
   * @acclevel=03.
   */
  boolean checkEn;

  /**...Comment.
   * @acclevel=30.
   */
  float tune_fY12;

  /**...Comment.
   * @acclevel=11.
   */
  struct ParFactors_PIDf_Ctrl_emC_t * par_PID;
} ParamOptimizer_ObjMod_s;

extern_C ClassJc const refl_ParamOptimizer_ObjMod;

void ctor_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz);


/**Write data to DataStruct. 
 * Note: The Simulink coder cannot decide whether it is a scalar, vector or pointer
 * Therefore all arguments are unique given as address (pointer) 
 */

bool init__ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float const* tune_fY12, uint32 const* par_PID);


void step__ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float const* f_Y12, float const* reserve, float const* Ystim, bool const* checkEn);


inline void get_f_Y12_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float* f_Y12) {
  *f_Y12 = thiz->f_Y12;
}

inline void get_reserve_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float* reserve) {
  *reserve = thiz->reserve;
}

inline void get_Ystim_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float* Ystim) {
  memcpy(Ystim, thiz->Ystim, sizeof(thiz->Ystim));//float
}

inline void get_checkEn_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, boolean* checkEn) {
  *checkEn = thiz->checkEn;
}

inline void get_tune_fY12_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float* tune_fY12) {
  *tune_fY12 = thiz->tune_fY12;
}

inline void get_par_PID_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, uint32* par_PID) {
  //In the simulink data a handle is stored, in the generated struct it is a really pointer. Convert it:
  *par_PID = HANDLE_Handle2Ptr(thiz->par_PID);
}

inline void set_tune_fY12_ParamOptimizer_ObjMod(ParamOptimizer_ObjMod_s* thiz, float* tune_fY12) {
  thiz->tune_fY12 = *tune_fY12;
}
#endif  //__ParamOptimizer_ObjMod_h__
