#ifndef __ProgrSimpleExmplA_MeasPrep_h__
#define __ProgrSimpleExmplA_MeasPrep_h__
#include <emc/Base/Object_emC.h>

/**The input data of the users model. 
 * The generator simulink_Sfn_SfH.jzTc generates
 * * Reflection
 * * Bus definition for simulink
 * * Sfunction wrapper.
 * In the Sfunction wrapper it is checked, whether the bus layout matches to the struct memory layout. 
 * @simulink bus.
 */
typedef struct Input_MeasPrep_ProgrSimpleExmplA_t
{
  /**Position value first */
  float s1;
  
  /**Any validy of analog values. It is int16 to test with bus positions.*/
  uint16 validy;
  
  /**Another value for anything, only for test of bus positions /mapping with bus definition.
   * change to uint32 to provocate an error. */
  uint16 v2;

  /**Position value second. */
  float s2;

} Input_MeasPrep_ProgrSimpleExmplA;



/**The input data of the users model.
 * @simulink no-bus.
 */
typedef struct MeasPrep_ProgrSimpleExmplA_t
{
  /**Based on ObjectJc, necessary for Sfunction. 
   * @acclevel=47.
   */  
  union { ObjectJc obj; } base;  
    
  /**Position value of first head. */
  float s1;

  /**Position value of second head. */
  float s2;

} MeasPrep_ProgrSimpleExmplA;


/**Constructor.
 * @simulink ctor
 */
MeasPrep_ProgrSimpleExmplA* ctor_MeasPrep_ProgrSimpleExmplA(ObjectJc* othiz, float Tstep);

/**Saves the input bus data.
 * @simulink Object-FB
 */
inline void step_MeasPrep_ProgrSimpleExmplA(MeasPrep_ProgrSimpleExmplA* thiz, Input_MeasPrep_ProgrSimpleExmplA* x_bus){
 thiz->s1 = x_bus->s1;
 thiz->s2 = x_bus->s2;
}

/**Saves the input bus data.
 * @simulink Operation-FB
 */
inline void out_MeasPrep_ProgrSimpleExmplA(MeasPrep_ProgrSimpleExmplA* thiz, float* s1_y, float* s2_y){
 *s1_y = thiz->s1;
 *s2_y = thiz->s2;
}

#endif //__ProgrSimpleExmplA_MeasPrep_h__