#ifndef __Data_Test_OrthOsc2_h__
#define __Data_Test_OrthOsc2_h__
/**This file describes data which are used in the Simulink module Test_OrthOsc2.
 * From this header some buses in simulink are generated
 * and some ObjectOriented access blocks are genrated.
 */

/**regards system conventions different between Simulink modell test level 
 * and target system.
 */
#include <applstdefJc.h>  
//#include <compl_adaption.h>
//#include <Fwc/objectBaseC.h>

/**The used Sfunc modules.
 */
#include <AngleBlocks_FB.h>       
#include <OrthOsc_FB.h>
#include "Output_Test_OrthOsc2.h"

/**The macro OS_HandlePtr for handles in Simulink or pointer in target.*/
#include <Fwc/fw_handle_ptr64.h>  






/*@CLASS_C Data_Test_OrthOsc2 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@q*/


/**Sub-Bus for OrthOsc handle. 
 * Structure of data for inspector/reflection access
 * of the Simulink module both for Simulink level and code-generated target.
 * @simulink no-bus
 */
typedef struct BusOrth_Test_OrthOsc2_t
{
  OS_HandlePtr(OrthOsc2_FB, osc1[2]);
  OS_HandlePtr(OrthOsc2_FB, osc2[2]);
  OS_HandlePtr(OrthOsc2_FB, osc3[2]);
  OS_HandlePtr(Adjustk_OrthOsc2_FB, adj[2]);

} BusOrth_Test_OrthOsc2;


/**Internal struct for inspector access for this module. 
 * Structure of data for inspector/reflection access
 * of the Simulink module both for Simulink level and code-generated target.
 * @simulink no-bus
 */
typedef struct Data_Test_OrthOsc2_t
{
  
  union { ObjectJc obj; } base;

  /**The output data of the module. */
  OS_HandlePtr(Output_Test_OrthOsc2, out);
  
  OS_HandlePtr(OrthOsc2_FB, osc1[2]);
  OS_HandlePtr(OrthOsc2_FB, osc2[2]);
  OS_HandlePtr(OrthOsc2_FB, osc3[2]);
  OS_HandlePtr(Adjustk_OrthOsc2_FB, adj[2]);
  
  /**The private object data of the Object-FB. */
  //OS_HandlePtr(BusOrth_Test_OrthOsc2, orthOsc);



} Data_Test_OrthOsc2;


/**Constructor for the Object-FB to access data via inspector.
 * @simulink ctor
 */
void ctor_Data_Test_OrthOsc2(Data_Test_OrthOsc2* thiz, float Tstep);




/**This operation assembles some references and stores the handle to this struct.
 * If it is invoked as S-function in simulink, the references comes from the global static handle2Ptr-array 
 * This routine converts the references back to the handle and stores the handle.
 * If this operation is invoked in the target it runs in the Tinit step time.
 * It stores the reference value of the input buses immediately which is the pointer. 
 * @simulink init
 */
INLINE_Fwc char const* init_Data_Test_OrthOsc2(Data_Test_OrthOsc2* thiz, Output_Test_OrthOsc2* out
  , OrthOsc2_FB* osc1[2], OrthOsc2_FB* osc2[2], OrthOsc2_FB* osc3[2]
  , Adjustk_OrthOsc2_FB* adj[2]) //, BusOrth_Test_OrthOsc2* orth_bus)
{
#ifndef __NoReflection__  
  const char* error = null;
  //store the handle in the struct instead address, adequate like in a bus. 
  //The inspector knows the handle concept and accesses the correct data.
  error = handle_Handle2Ptr(out, &thiz->out); 
  int ix;
  int bOk = 1;
  if(out !=null     && error == null) { error = handle_Handle2Ptr(out, &thiz->out);         } else bOk = 0;
  if(osc1[0] !=null && error == null) { error = handle_Handle2Ptr(osc1[0], &thiz->osc1[0]); } else bOk = 0;
  if(osc1[1] !=null && error == null) { error = handle_Handle2Ptr(osc1[1], &thiz->osc1[1]); } else bOk = 0;
  if(osc2[0] !=null && error == null) { error = handle_Handle2Ptr(osc2[0], &thiz->osc2[0]); } else bOk = 0;
  if(osc2[1] !=null && error == null) { error = handle_Handle2Ptr(osc2[1], &thiz->osc2[1]); } else bOk = 0;
  if(osc3[0] !=null && error == null) { error = handle_Handle2Ptr(osc3[0], &thiz->osc3[0]); } else bOk = 0;
  if(osc3[1] !=null && error == null) { error = handle_Handle2Ptr(osc3[1], &thiz->osc3[1]); } else bOk = 0;
  for(ix=0; ix < 2; ++ix) {
    if(adj[ix] !=null && error == null) { error = handle_Handle2Ptr(adj[ix], &thiz->adj[ix]); } else bOk = 0;
  }
  if(bOk) { //all set:   
    setInitialized_ObjectJc(&thiz->base.obj);
  }
  return error;  //it produces an simulink error output if not null.
#endif//__NoReflection__
}

/**Empty operation all is done in init.
 * @simulink Object-FB, accel-tlc
 */
INLINE_Fwc int set_Data_Test_OrthOsc2(Data_Test_OrthOsc2* thiz){return 0; }  //only empty.



#endif //__Data_Test_OrthOsc2_h__
