#ifndef __Test_ArrayVoid_SmlkObjO_h__
#define __Test_ArrayVoid_SmlkObjO_h__
/**This file defines a Sfunction which deals with dynamically typed 
 * and dynamically sized inputs and output.
 */

/**regards system conventions different between Simulink modell test level 
 * and target system.
 */
#include <applstdefJc.h>  





/*@CLASS_C Test_ArrayVoid_SmlkObjO @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@q*/


/**Example data
 * @simulink no-bus
 */
typedef struct Test_ArrayVoid_SmlkObjO_t
{ ObjectJc base;
  int size;
  char type;
  char dummy[3];  //think about 4-byte-alignment.
} Test_ArrayVoid_SmlkObjO;



/**Constructor for the Object-FB to access data via inspector.
 * @simulink ctor
 */
INLINE_Fwc void ctor_Test_ArrayVoid_SmlkObjO(Test_ArrayVoid_SmlkObjO* thiz, DefPortTypesJc* portInfo)
{
#ifndef __ignoreInCheader_zbnf__  
  thiz->size = portInfo->entries[0].sizeArray[0];  //from Port 0
  thiz->type = portInfo->entries[0].type;
  setInitialized_ObjectJc(&thiz->base);
#endif//__ignoreInCheader_zbnf__
}

/**Check routine invoked in Sfunction to transfer the size from input to output.
 * @simulink defPortTypes.
 */
INLINE_Fwc void setSizeOutput(DefPortTypesJc* portInfo)
{
  //set Output arg 0, it is Input
  portInfo->entries[portInfo->ixOutputStep].sizeArray[0] = portInfo->entries[0].sizeArray[0];   
}



/**This operation assembles some references and stores the handle to this struct.
 * If it is invoked as S-function in simulink, the references comes from the global static handle2Ptr-array 
 * This routine converts the references back to the handle and stores the handle.
 * If this operation is invoked in the target it runs in the Tinit step time.
 * It stores the reference value of the input buses immediately which is the pointer. 
 * @xxxsimulink init.
 */
INLINE_Fwc char const* init_Test_ArrayVoid_SmlkObjO(Test_ArrayVoid_SmlkObjO* thiz) {
}

/**Empty operation all is done in init.
 * @simulink Object-FB, accel-tlc, no-thizStep.
 */
INLINE_Fwc void step_Test_ArrayVoid_SmlkObjO(Test_ArrayVoid_SmlkObjO* thiz
  , float const input[], float output_y[] ) 
{
#ifndef __ignoreInCheader_zbnf__  
  int ix;
  for(ix = 0; ix < thiz->size; ++ix) {
    //do something for all elements of input and ouput:
    output_y[ix] = 2.0f * input[ix];
  }
#endif//__ignoreInCheader_zbnf__
}  



#endif //__Test_ArrayVoid_SmlkObjO_h__
