@echo off
REM This file contains the JZtxtcmd parts to configure the SimSelector tool
REM and contains also the start of the SimSelector tool as windows cmd line call. 

::SET LOGDIR=%~d0%~p0\stimuli_Selection_Log_deleteMe
SET LOGDIR=stimuli_Selection_Log_deleteMe
if not exist %LOGDIR% mkdir %LOGDIR% 

REM invoke from current dir, where this file is stored, not invoke with the Simulink root path.
REM Decision whether a 32.bit or 64.bit SWT library should be used depends on the java version 32 or 64, not on the Operation System.
::set SWTJAR=org.eclipse.swt.win32.win32.x86_3.5.1.v3555a.jar
::set SWTJAR=org.eclipse.swt.win32.win32.x86_64_3.106.0.v20161027-0130.jar
set SWTJAR=org.eclipse.swt.win32.win32.x86_64.jar

set JAVA_CP=../../../../../libs/vishiaGui.jar;../../../../../libs/vishiaBase.jar;../../../../../libs/%SWTJAR%

REM because javaw is used, the console window remain open but can be closed manually independent of the java run.
REM The >out and >err can be used. Hint: If start would be used here, >out and >err do not work. 
REM   Then no information is given on faulty conditions, especially missing jars.
REM   Therefore 'start' should not be used here.
REM write out the command line to help explore the starting conditions on faulty situation:
REM invokes the stimuli selection GUI
@echo on  
javaw -cp %JAVA_CP% org.vishia.simSelector.SimSelector createStimuli.jzT.cmd 1>%LOGDIR%\log.txt 2>%LOGDIR%\err.txt
@echo off
if %ERRORLEVEL% == 0 goto :noerror
  type %LOGDIR%\err.txt
  pause
:noerror
REM Hint: exit /b means, the console window remain open though this called batch will be finished. exit pure closes the console.
exit /b

==JZtxtcmd==

String dirMdl = "test/Smlk/+inspcStimuli";
String dirSimulink = "..";  ##the directory for this model in simulink
Filepath outputCsvStimuli = "+genstimuli/testStimuli.m.csv";
String fileStimuli_inspc  = "+genstimuli/genStimuli_inspc.jz.cmd";
String fileStimuli_m      = "+genstimuli/genStimuli.m";
String fileTestCases_m    = "+genstimuli/genTestCases.m";


##This list will be dynamically filled if its elements are accessed
##if it contains a Subtextvar. The source variable are taken from the environment.
##This is a feature of JZtxtcmd for symbolic dynamic access.
##It means line1 .. line6 are variables in context, where an element of vars is accessed.
##The list contains the values which should be prepared for a selection.
List vars =
[ Subtextvar name = <:><&line1.name>_<&line2.name>_<&line3.name>_<&line4.name>_<&line5.name>_<.>;
  Subtextvar Description = <:><&line1.descr> <&line2.descr> <&line3.descr> <&line4.descr> <&line5.descr><.>;
  Subtextvar Identifier =  <:><&line1.name>_<&line2.name>_<&line3.name>_<&line4.name>_<&line5.name><.>; 
  String     activate = "1";
  Subtextvar t1 = <:><&line1.t1><.>;
  Subtextvar t2 = <:><&line1.t2><.>;
  Subtextvar t3 = <:><&line1.t3><.>;
  Subtextvar val1 = <:><&line2.val1><.>;
  Subtextvar val2 = <:><&line2.val2><.>;
  Subtextvar val3 = <:><&line2.val3><.>;
  Subtextvar spline = <:><&line3.spline><.>;
  Subtextvar nref = <:><&line1.nref><.>;
  Subtextvar Mref = <:><&line2.Mref><.>;
];                                                                                          

##Character for test case selection:
## M All moment force
## n All rotation speeds

List variation_1 @name =  ##times
[ { name="slow",  select="s1",     t1="3.0", t2="5.0", t3="8.0", descr="slow cycle"    } 
, { name="slow2", select="s2 Std", t1="2.0", t2="5.0", t3="6.0", descr="middle cycle"    }
, { name="mid1",  select="m1",     t1="2.0", t2="4.0", t3="6.0", descr="middle cycle"    }
, { name="mid2",  select="m2",     t1="2.0", t2="3.0", t3="4.0", descr="faster cycle"    }
, { name="fast",  select="f",      t1="1.0", t2="1.7", t3="2.5", descr="fast cycle"    }
];

List variation_2 @name =  ##levels
[ { name="low1",   select="l1", val1="=>1.0", val2="=>1.5", val3="=>0.5", descr="/ 1.5 \ "    } 
, { name="low2",   select="l2", val1="=>1.0", val2="=>2.5", val3="=>0.5", descr="/ 2.5 \ "    }
, { name="jlow2",  select="lj2", val1="=>1.0", val2="=2.5",  val3="=0.5",  descr="- 2.5 - "    }
, { name="mid1",   select="m1 Std", val1="=>1.0", val2="=>3.5", val3="=>0.5", descr="/ 3.5 \ "    }
, { name="jmid1",  select="mj", val1="=>1.0", val2="=3.5",  val3="=0.5",  descr="- 3.5 - "    }
, { name="midup",  select="u", val1="=>1.0", val2="=>4.5", val3="=>8.0", descr="/ 4.5 / 8 "    }
, { name="high1",  select="h1", val1="=>1.0", val2="=>8.0", val3="=>0.0", descr="/ 8.0 \ "    }
, { name="jhigh1", select="hj", val1="=>1.0", val2="=8.0",  val3="= 0.0", descr="- 8.0 - "    }
, { name="high2",  select="hl", val1="=>8.0", val2="=>0.5", val3="=>8.0", descr="8 \ 0.5 / 8 "    }
, { name="jhigh2", select="hlj", val1="=>8.0", val2="=0.5",  val3="=8.0",  descr="8 - 0.5 - 8 "    }
];
                                                            
                                                                   
List variation_3 @name = ##spline
[ { name="ramp",           select="R", spline="",      ramp=">",  descr="ramp"    } 
, { name="fastSpline",     select="S0", spline="-0.05", ramp=">",  descr="0.05"    }
, { name="midSpline",      select="S1 Std", spline="-0.1",  ramp=">",  descr="0,1"    }
, { name="slowSpline",     select="S2", spline="-0.3",  ramp=">",  descr="spline=0.3"    }
, { name="verySlowSpline", select="S3", spline="-1.0",  ramp=">",  descr="spline=1.0"    }
];

                                

List variation_4 @name =                                            
[ { name = "Filter_1",   select="F1 Std",descr="filter 1", Filter_switch_c1="1" }
, { name = "Filter_0",   select="F2",descr="filter 0", Filter_switch_c1="0" }
];
                                                                
                               
List variation_5 @name =   ##unused         
[ { name="x",  select="",     descr="dummy"    } 
];

List variation_6 @name =   ##unused         
[ { name="x",  select="",     descr="-empty-"    } 
];


List variations;
variations.add(variation_1);
variations.add(variation_2);
variations.add(variation_3);
variations.add(variation_4);
variations.add(variation_5);
variations.add(variation_6);


class ToGui 
{
  List tdata1 = variation_1;
  List tdata2 = variation_2;
  List tdata3 = variation_3;
  List tdata4 = variation_4;
  List tdata5 = variation_5;
  List tdata6 = variation_6;
}

