echo off
REM call of this file generates one stimuli file with the given settings.
REM Settings are cmd line arguments written -u:<&line1.name> ...etc for JZtxtcmd

REM Note: Invocation from its own directory or from the simulink root dir.
REM cd to the simulink root dir if necessary
if exist mdlStimuli_SelectionTool.jzT.cmd cd ..\..\..\..

REM The JZtxtcmd start file is not this, it is mdlStimuli_SelectionTool.jzT.cmd, 
REM because that file includes some more and also this.
REM Argument writing style is -u:KEY to designate as user argument for the main ()
java -cp ../libs/vishiaBase.jar org.vishia.jztxtcmd.JZtxtcmd test/Smlk/+inspcStimuli/+stimuli/createStimuli.jzT.cmd %1 %2 %3 %4 %5 %6

exit /B



==JZtxtcmd==

 include Stimuli_template.m.jztc;       ##the template for the simulink stimuli file for this model
 include SetInspcArgs_template.jzTc;    ##the template for Inspc stimuli
 include Stimuli_SelectionTool.jzT.cmd; ##contains the tables for selection
 
 currdir = <:><&scriptdir>/../../../..<.>; ##it is the root of the Smlk working tree
 
 

 ##
 ##This main routine is used to generate the stimuli file.m from the Simulink simulation m-file
 ## the arguments are the keys sorted to the tables.
 ##
 main ( ) {
   <+out>stimuli_scripts/createStimuli.jzT.cmd: main(<&$1>, <&$2>, <&$3>, <&$4>, <&$5> )<.+n>
   call genStimuli(key1 = &$1, key2 = &$2, key3 = &$3, key4 = &$4, key5 = &$5 );                  
 }
 



 ##
 ##This routine is used for some given keys for lines. 
 ##It searches the line and call the same as the btnGenSelection in the SimSelector GUI 
 ##It is used especially to execute a name-given stimuli generation.
 ##
 sub genStimuli(String key1, String key2, String key3, String key4, String key5, String key6){
   ##T: should be used as the temporary output for debugging, it may be a RAM disk, only temporary
   
   ##if(not File:"T:\".exists() ) {  cmd cmd.exe /C subst T: d:\tmp; }
   <+out><&scriptdir>/createStimuli.jzT.cmd: genStimuli(key1="<&key1>", key2="<&key2>", key3="<&key3>", key4="<&key4>", key5="<&key5>") .....<.+n>
   
   Num found = 0;
   Obj var1 = variation_1.get(key1);
   Obj var2 = variation_2.get(key2);
   Obj var3 = variation_3.get(key3);
   Obj var4 = variation_4.get(key4);
   Obj var5 = variation_5.get(key5);
   <+out><&var1> <&var2> <&var3> <&var4> <.+n>
   if(var1 !=null && var2 !=null && var3 !=null && var4 !=null) {  ##Note: key5 may not used. 
     found = 1;
     call btnGenSelection(line1=var1, line2=var2, line3=var3, line4=var4, line5=var5, line6="");  
   }  
   if(not found){ <+out>No stimuli case found. <.+n> }
 }







sub genCsv(){
  ##T: should be used as the temporary output for debugging, it may be a RAM disk, only temporary
  
  ##if(not File:"T:\".exists() ) {  cmd cmd.exe /C subst T: d:\tmp; }
  <+>Generate Stimuli-csv-A<.+n>
  
  List texts = ["ab", "cd"];             
  
  
  Openfile outs = outputCsvStimuli;
  for(var: vars){                                                              
    <+outs><&var.name>, <.+>
  }
  <+outs>                                   
  <.+>
  ##create all stimuli lines:
  ##Subtext test1 = <:>YTestA_<&varImpedance.name>_<&varShType.name><.>;
  for(var1: variation_1) {
    for(var2: variation_2) {
      for(cell: vars) {
        <+outs><&cell>, <.+>
      }
      <+outs><.+n>
  } }
}



 ##
 ##This routine will be called from inside the Java programm org.vishia.simSelector.SimSelector
 ##  on the button gen selection. It generates the selected test case.
 ##  @args: Map contains some named variables which are processed in genSelection(...)
 ##
 sub btnGenSelection ( Map line1, Map line2, Map line3, Map line4, Map line5, Map line6) {
   <+out><&scriptdir>/<&scriptfile>: btnGenSelection ( <: >
     <&line1.name>, <&line2.name>, <&line3.name>, <&line4.name>, <&line5.name>) ..... <.+n> 
   Map data;
   for(cell: vars) {    
     String value = <:><&cell><.>;  ##Fills elements of Subtextvar with current data
     data.put(cell.name, value);    ##create all variables in data using the elements of vars
   }
   <+out>found <&data.Identifier><.+n> 
   ##
   ##Output the files which are used from Simulink.
   ##
   //debug;
   <+out><&data.Identifier>.m<.+n>
   <+out>open <&dirMdl>/<&fileStimuli_m><.+n>           ##this variable are defined in the including Stimuli_SelectionTool.jzT.cmd
   Openfile sf = <:><&dirMdl>/<&fileStimuli_m><.>; 
   <+sf>
   <:subtext:"stimuliMat":data = &data>  ##write this subtext to thr file
   <.+close>
   //
   <+out>open <&dirMdl>/<&fileStimuli_inspc><.+n>
   Openfile sf = <:><&dirMdl>/<&fileStimuli_inspc><.>; 
   <+sf>
   <:subtext:"stimuliInspc":data = &data>  ##write this subtext to thr file
   <.+close>
   <+out> ...ok<.+n> 
 }



                                                                                                            


 ##
 ##It produces the Matlab script to run a selection;
 ##The file name given as argument, default for button in GUI.
 ##This operation is called immediately in a ...createProgrammedTestCases and in the SimSelector GUI
 ##
 sub genTestcases(String select, String name="genTestCases") {
   <+out><&scriptdir>/<&scriptfile>: genTestcases(<&select>, <&name>) .....<.+n>
   ##create all stimuli lines:
   ##Subtext test1 = <:>YTestA_<&varImpedance.name>_<&varShType.name><.>;
   String ffcases = <:><&dirMdl>/+genstimuli/<&name>.m<.>;
   <+out>currdir=<&currdir>
   file fcases = <&ffcases>
   <.+n>
   Openfile fcases = ffcases; 
   ##Openfile fcsv = <:><&dirMdl>/+genstimuli/<&name>.csv<.>; 
   <+fcases>
   <:>
 ==%cuis the rrdir = fullfile(rootPath,'test/Smlk/+inspcStimuli/+stimuli')   %the path from simulink currdir.
 ==%cd(currdir);
 ==
 ==%%Fills the array of test cases
 ==clear testcases;
 ==ix = 1;
 ==<.><.+>
   if(fcsv) { <+fcsv>"Name", "Description", "todo",<.+n>; }    
  Obj testcases = java org.vishia.testutil.TestConditionCombi.prepareTestCases(select, 5); 
  Num ixcase = 1;
  for(testcase: testcases) {
    
    String name = <:><:for:var:testcase><&var.sel><:hasNext>_<.hasNext><.for><.>; 
    <+out>test case: <&name><.+n> 
    <+fcases><: >
    <:>
 ===testcases{ix, 1} = '<:for:var:testcase> -u:<&var.sel><.for>'; ix = ix +1; <.><.+>
    if(fcsv) {
      <+fcsv>"TestA_<&name>", "<&var1.descr>_<&var2.descr>_<&var3.descr>_<&var4.descr>_<&var5.descr>"<.+n>
    }
    ixcase = ixcase + 1; 
  }  
   <+fcases>
   <:>
 ==
 ==for ix = 1 : size(testcases)
 ==  disp('====================== Prepare Simuli file =========================');
 ==  args = testcases{ix};  %curly braces
 ==    %The next script generates the stimuli file.m with the given args using this script too
 ==    cmd = strcat('test\Smlk\+inspcStimuli\+stimuli\createStimuli.jzT.cmd', args);
 ==    disp(cmd);
 ==    system(cmd);                            %generates genStimuli.m
 ==    disp('====================== START Simulation ==========================');
 ==    sim('+inspcStimuli/TestInspcStimuliMdl.mdl');
 ==    
 ==end    
   <.><.+>
   fcases.close();      
   ##fcsv.close();
 }
  


